/*
 * This file contains various commands that are used by the new client/server
 *	++Jam
 */

#include <global.h>
#include <commands.h>
#include <sproto.h>

#ifndef tolower
#define tolower(C)      (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))
#endif


static int compare_A(const void *a, const void *b)
{
  return strcmp(((CommArray_s *)a)->name, ((CommArray_s *)b)->name);
}

static CommArray_s *find_command_element(char *cmd, CommArray_s *commarray,
    int commsize)
{
  CommArray_s *asp, dummy;
  char *cp;

  for (cp=cmd; *cp; cp++)
    *cp =tolower(*cp);

  dummy.name =cmd;
  asp =(CommArray_s *)bsearch((void *)&dummy,
			      (void *)commarray, commsize,
			      sizeof(CommArray_s), compare_A);
  return asp;
}

int execute_newserver_command(object *pl, char *command)
{

  CommArray_s *csp;
  char *cp;

  pl->contr->has_hit=0;
  /*
   * No arguments?
   */
  if (!(cp=strchr(command, ' '))) {
      if ((csp=find_command_element(command, NewServerCommands,
	NewServerCommandSize))==NULL)
	    csp=find_command_element(command, Commands, CommandsSize);

	if (csp==NULL) {
	    char buf[MAX_BUF];

	    sprintf(buf, "'%s' is not a valid command.", command);
	    new_draw_info(NDI_UNIQUE, 0,pl, buf);
	    return 0;
	}
	pl->speed_left -= csp->time;
#if 0
	if (csp->time && csp->time>pl->speed_left) {
#endif
	/* A character time can never exceed his speed (which in many cases,
	 * if wearing armor, is less than one.)  Thus, in most cases, if
	 * the command takes 1.0, the player's speed will be less than zero.
	 * it is only really an issue if time goes below -1
	 * Due to various reasons that are too long to go into here, we will
	 * actually still execute player even if his time is less than 0,
	 * but greater than -1.  This is to improve the performance of the
	 * new client/server.  In theory, it shouldn't make much difference.
	 */
	if (csp->time && pl->speed_left<-2.0) {
		LOG(llevDebug,"execute_newclient_command: Player issued command that takes more time than he has left.\n");
	}
	return csp->func(pl, NULL);
  }
  /*
   * Command with some arguments
   */

  *(cp++) ='\0';
    if ((csp=find_command_element(command, NewServerCommands,
	NewServerCommandSize))==NULL)
	    csp=find_command_element(command, Commands, CommandsSize);

    if (csp==NULL) {
	char buf[MAX_BUF];

	sprintf(buf, "'%s' is not a valid command.", command);
	new_draw_info(NDI_UNIQUE, 0,pl, buf);
	return 0;
    }
    pl->speed_left -= csp->time;
    if (csp->time && pl->speed_left<-1.0) {
	LOG(llevDebug,"execute_newclient_command: Player issued command that takes more time than he has left.\n");
    }
    return csp->func(pl, cp);
}

int command_run(object *op, char *params)
{
    op->contr->run_on=1;
    draw_message_window(op);
    return (move_player(op, params?atoi(params):0));
}

int command_run_stop(object *op, char *params)
{
    op->contr->run_on=0;
    draw_message_window(op);
    return 1;
}

int command_fire(object *op, char *params)
{
    op->contr->fire_on=1;
    draw_message_window(op);
    return move_player(op, params?atoi(params):0);
}

int command_fire_stop(object *op, char *params)
{
    op->contr->fire_on=0;
    draw_message_window(op);
    return 1;
}

int bad_command(object *op, char *params)
{
    new_draw_info(NDI_UNIQUE, 0,op,"bind and unbind are no longer handled on the server");
    return 1;
}
