
#ifndef NEWSERVER_H
#define NEWSERVER_H
#define MAXMAPCELLFACES 50

/* To pull in some typdefs */
#include <structs.h>

struct MapCell {
  short faces[MAXMAPCELLFACES];
  int count;
};

struct Map {
  struct MapCell cells[11][11];
};

/* True max is 16383 given current map compaction method */
#define MAXFACENUM  5000

struct statsinfo {
    char *range, *title;
};


/* This contains basic information on the socket structure.  status is its
 * current state.  we set up our on buffers for sending/receiving, so we can
 * handle some higher level functions.  fd is the actual file descriptor we
 * are using.
 */
enum FaceSendMode { Send_Face_Pixmap, Send_Face_Bitmap, Send_Face_None };

enum Sock_Status {Ns_Init, Ns_Add, Ns_Dead};
typedef struct NewSocket {
    enum Sock_Status status;
    int fd;
    enum FaceSendMode facemode;
    uint32  client_id;
    struct Map lastmap;
    uint8 faces_sent[MAXFACENUM];
    struct statsinfo stats;
    /* If we get an incomplete packet, this is used to hold the data. */
    SockList	inbuf;
    char    *host;  /* Which host it is connected from */
    uint32  sent_scroll:1;
} NewSocket;

extern NewSocket *cs_sockets;

#endif
