

/* Created '95 Oct by b.t. */

/* the Gods array.
 * If you change the number of gods in the array, dont forget to change
 * the value of NROFGODS (in define.h).
 */

/* Meaning/uses of Gods array values. If a value is not required to be
 * specified in the array, it is noted below.
 *
 * name         - name of the god  (required)
 * enemy        - diametrically opposed god, use "none" if none exists
 *                (required)
 * attacktype   - favored attack of this god, used in spells of summon
 *                avatar, holy word. Recipients of "holy possession" get too.
 *                (required)
 * immune       - Recipient of "holy possession" gets this.
 * protected    - Priest of this god gets this.
 * vulnerable   - Priest of this god and recipient of "curse" spell gets this.
 * path_attuned - priest of this god and recipient of "bless" gets this
 * path_repelled - priest and recipient of "curse" gets this
 * path_denied  - priest and recipient of "curse" gets this
 * aligned_race - the name of the race of creatures that are aligned w/ the god.
 *		  "summon cult monsters" and "pacify" are 2 spells that use this. 
 *		  Value must be "none" if no race exists. (required)
 * enemy_race   - name of the race of creatures "holy word","holy possession" 
 *		  spells will effect. Used by other things too. Value entry must 
 *		  be "none" if no such race exists.  (required)
 * desc		- comma delimited list of descriptive terms.
 */

/* name,enemy,attacktype,immune,protected,vulnerable,
 * path_attuned,path_repelled,path_denied,aligned_race,enemy_race
 */

god Gods[NROFGODS] = {
/* ------CHRISTIAN MYTHOS GODS -------*/
/* the Christian god */
{"God",         "Satan",  AT_FEAR|AT_WEAPONMAGIC, 66688, 66688,    0,
                PATH_RESTORE|PATH_TURNING, PATH_NULL, PATH_WOUNDING, 
		"angel", "undead,demon",NULL},
/* the Christian "devil" */
{"Satan",       "God",    AT_ACID|AT_FIRE,   132,   132,  128,
                PATH_WOUNDING,  PATH_LIGHT, PATH_RESTORE,     
		"undead,demon", "angel", "the Lord of lies"},
/* -----NON-HUMAN MYTHOS GODS --------*/
/* the God of Orcs/Goblins  */
{"Gnarg",       "Lythander",  AT_POISON,    1024,   1024,  16384,
                PATH_WOUNDING, PATH_TURNING|PATH_RESTORE|PATH_LIGHT,
		PATH_NULL, "goblin,troll,giant", "sylvan,elven",
		"father of goblins,patron to assasins"},
/* the Elven God of Luck - an ancient foe of Orcs/Goblins/trolls */
{"Lythander",   "Gnarg",     AT_MAGIC,   2,   2,     1024,
                PATH_TURNING|PATH_MISSILE, PATH_SUMMON, PATH_DEATH,
		"sylvan,elven",  "goblin,troll",
		"Elven god of luck,Huntsman of goblins,Trollslayer"},
/* the Dwarven Smith God. Lives in a magical cave far from civilization. */ 
{"Mostrai",     "Gnarg",     AT_PHYSICAL,   1,   0,     0,
                PATH_CREATE, PATH_NULL, PATH_NULL,
		"dwarf",  "goblin,troll,giant",
		"Dwarven diety of smithing"},
/* Below are some spare gods, mostly these are related to my 
 * maps and so may not be useful to all. I left them in mainly so there 
 * would be more examples of the possibilities for gods. -b.t. */
#if 0
/* -----LAW-ALIGNED MYTHOS GODS -------*/
/* Protector God of the Golden City aligned w/ forces of Law. 
 * Chaos fighter. Not a very powerfull god, but is arch-enemy of Ruggilli. 
*/ 
{"Aural'il",    "Ruggilli",   AT_WEAPONMAGIC,  1056, 263200,  0,
                PATH_PROT|PATH_MIND, PATH_TURNING|PATH_WOUNDING, PATH_NULL,  		
		"law", "demon,chaos,dragon",
		"Patron god of the Golden City,Giver of peace"},
/* Law Goddess of Nature/Agrigulture/Healing in Sundying lands. */
{"The Shining Goddess", NULL,   AT_FEAR|AT_BLIND,    1024,   1026,  0,
                PATH_TURNING|PATH_RESTORE|PATH_LIGHT, PATH_NULL, PATH_DEATH|PATH_WOUNDING,
                "law", "undead,troll,chaos",
                "Lifegiver,The Earth Mother"},
/* -----CHAOS-ALIGNED MYTHOS GODS ------*/
/* God of War in Sundying lands, a formidible Chaos god. 
 * Often seen as a flying serpent. 
 */ 
{"Ruggilli",    NULL,   AT_WEAPONMAGIC|AT_CONFUSE,    262144,  262146,  32,
                PATH_WOUNDING, PATH_RESTORE|PATH_PROT, PATH_NULL,  
		"demon,chaos,dragon", "law",
		"Chaos God of slaughter,Fang of Chaos"},
/* -----UN-ALIGNED "BALANCE" GODS ------*/
/* Gods of Dead/Undead/Knowledge in Sundying lands. 
 * Neither Chaos or Law aligned. 
 */ 
{"The Devourers",    NULL,  AT_DRAIN|AT_PARALYZE,   65665, 65665,  4,
                PATH_INFO|PATH_SUMMON, PATH_TURNING|PATH_PROT, PATH_RESTORE,   
		"undead", "undead",
		"Lords of the Forgotten"},
#endif
};

