/*
 * static char *rcsid_global_h =
 *   "$Id: global.h,v 1.34 1997/03/09 04:53:44 master Exp master $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to mark@pyramid.com.
*/

#ifndef GLOBAL_H
#define GLOBAL_H

#ifndef EXTERN
#define EXTERN extern
#endif

#include "includes.h"

#define NUM_COLORS		13
#define DEFAULT_PLAYER_FG	0
#define DEFAULT_PLAYER_BG	8
#define DEFAULT_PLAYER_FIELD	12

#define XDRAWIMAGESTRING(disp,win,gc,x,y,str,len) \
XDrawImageString16(disp,win,gc,x,y,str,len)
#define FontindexToXChar(s) fontindex_to_XChar2b(s)
#define XCharToFontindex(s) ((Fontindex) ((s).byte1*256 +  (s).byte2))
typedef unsigned short Fontindex;
typedef XChar2b XChar; 


#include "structs.h"
#if defined(SOUND_EFFECTS) && !defined(__CEXTRACT__)
#include <rplay.h> /* RPLAY structure */
#endif

/*****************************************************************************
 * GLOBAL VARIABLES:							     *
 *****************************************************************************/


extern Settings settings;

extern char *colorname[NUM_COLORS][2];
extern New_Face *new_faces;

/*
 * These are the beginnings of linked lists:
 */
EXTERN player *first_player;
EXTERN mapstruct *first_map;
EXTERN treasurelist *first_treasurelist;
EXTERN artifactlist *first_artifactlist;
EXTERN archetype *first_archetype;
EXTERN objectlink *first_friendly_object;	/* Objects monsters will go after */
EXTERN sockets *first_socket;			/* Start of linked list of sockets */
EXTERN godlink *first_god;
EXTERN racelink *first_race;

/*
 * The editor uses these (will get them out of here later):
 */

EXTERN long editor;     /* if true, edit maps instead of playing (almost obsolete) */

/*
 * Variables set by different flags (see init.c):
 */

EXTERN int maplevel;
EXTERN long delete_last_file;
EXTERN long warn_archetypes;	/* If true, write warnings when failing */
				/* to find archetypes when loading from file */
EXTERN long init_done;			/* Ignores signals until init_done is true */
EXTERN long trying_emergency_save;	/* True when emergency_save() is reached */
EXTERN long nroferrors;		/* If it exceeds MAX_ERRORS, call fatal() */

extern long pticks;		/* used by various function to determine */
				/* how often to save the character */
/*
 * Misc global variables:
 */
EXTERN FILE *logfile;			/* Used by server/daemon.c */
EXTERN int exiting;			/* True if the game is about to exit */
EXTERN char *name;			/* The name of the game, usually "crossfire" */
EXTERN long last_micro;		/* When process_active_maps() was last exec */
EXTERN long nroftreasures;		/* Only used in malloc_info() */
EXTERN long nrofartifacts;		/* Only used in malloc_info() */
EXTERN long nrofallowedstr;		/* Only used in malloc_info() */

/* global stuff used by new skill/experience system -b.t. */ 
#define MAX_EXP_CAT 7 		/* This should be => # of exp obj in the game 
				 * remember to include the "NULL" exp object  
			         * EXP_NONE as part of the overall tally. 
				 */
#define EXP_NONE (MAX_EXP_CAT - 1)  /* "NULL" exp. object. This is the last 
				     * experience obj always.*/ 
EXTERN short nrofexpcat;	/* Current number of experience categories in the game */
EXTERN object *exp_cat[MAX_EXP_CAT];	/* Array of experience objects in the game */ 

EXTERN archetype *empty_archetype;	/* Nice to have fast access to it */
EXTERN archetype *map_archeytpe;
EXTERN char first_map_path[MAX_BUF];	/* The start-level */

#ifdef LONGJUMP
EXTERN jmp_buf jump_addr;
#endif
EXTERN Atom    Protocol_atom, Kill_atom;
EXTERN XClientMessageEvent *cmev;
EXTERN char errmsg[HUGE_BUF];
EXTERN long ob_count;
/*
 * Used in treasure.c
 */
EXTERN archetype *ring_arch,*amulet_arch,*staff_arch,*crown_arch;
EXTERN char *undead_name;	/* Used in hit_player() in main.c */
EXTERN sockets *active_socket;

extern int freearr_x[SIZEOFFREE], freearr_y[SIZEOFFREE];
extern int maxfree[SIZEOFFREE], freedir[SIZEOFFREE];

extern New_Face *blank_face;
extern New_Face *blocked_face;
extern New_Face *stipple1_face;
extern New_Face *stipple2_face;
extern New_Face *potion_face;
extern MapLook blank_look;
extern New_Face *inv_curse_face, *inv_damn_face, *inv_equip_face, *inv_lock_face,
         *inv_magic_face, *inv_unpaid_face;


#ifdef SOUND_EFFECTS
EXTERN RPLAY	*sound_table[NROF_SOUNDS];
#endif

extern long max_time;	/* loop time */

EXTERN char *font_graphic;

#ifndef __CEXTRACT__
#include <xdir.h>
#include "libproto.h"
#endif

#ifdef __hpux__ /* Must do this after including proto.h */
#define strdup_local(str) strdup(str);
#endif

#define set_map(M,X,Y,C)	((M)->map[(X)+((M)->mapx*(Y))]=*(C))
#define get_map(M,X,Y)		(&(M)->map[(X)+((M)->mapx*(Y))])
#define set_map_ob(M,X,Y,tmp)	((M)->map_ob[(X)+((M)->mapx*(Y))]=(tmp))
#define get_map_ob(M,X,Y)	((M)->map_ob[(X)+((M)->mapx*(Y))])
#define out_of_map(M,X,Y)	((X)<0||(X)>=(M)->mapx||(Y)<0||(Y)>=(M)->mapy)
#define get_map_floor(M,X,Y)	(&(M)->floor[(X)+((M)->mapx*(Y))])
#define set_map_floor(M,X,Y,C)	((M)->floor[(X)+((M)->mapx*(Y))]=*(C))

#ifdef DOUBLE_FLOOR
#define get_map_floor2(M,X,Y)	(&(M)->floor2[(X)+((M)->mapx*(Y))])
#define set_map_floor2(M,X,Y,C)	((M)->floor2[(X)+((M)->mapx*(Y))]=*(C))
#endif

#define decrease_ob(xyz) decrease_ob_nr(xyz,1)

#ifdef CALLOC
#undef CALLOC
#endif

#ifdef USE_CALLOC
# define CALLOC(x,y)	calloc(x,y)
# define CFREE(x)	cfree(x)
#else
# define CALLOC(x,y)	malloc(x*y)
# define CFREE(x)	free(x)
#endif

/*
 * Made this a macro since it's mostly used in time-critical areas:
 * (Hopefully a good optimizer will be able to move the if() out of
 * any loop where this macro is used.  That wouldn't have been possible
 * if this was a function!)
 */

/*
 * Have two version of this macro.  One if Xpm_Pix is defined, another
 * if Xpm_Pix is not defined.  IT would be better to actually have the
 * #ifdef's inside the macro itself, instead of having two versions, but
 * I was not able to get that to work.
 * Mark Wedel (mark@pyramid.com)
 */

#ifdef Xpm_Pix
#define draw_face(pl,win,gc,x,y,face) \
{ \
  if (pl->color_pixmaps) \
  { \
    XSetClipMask(pl->gdisp, gc, pl->masks[(face)]); \
    XSetClipOrigin(pl->gdisp, gc, x, (y) - 24); \
    XCopyArea(pl->gdisp, pl->pixmaps[(face)], win, gc, 0, 0, 24, 24, \
	(unsigned int) (x), (unsigned int) ((y) - 24)); \
  } \
  else if(pl->use_pixmaps) \
  { \
    XCopyPlane(pl->gdisp,pl->pixmaps[(face)],win,gc,0,0,24,24, \
               (unsigned int) (x),(unsigned int) ((y) - 24),1); \
  } \
  else \
  { \
    XChar buf; \
    buf = FontindexToXChar((Fontindex) (face)); \
    XDRAWIMAGESTRING(pl->gdisp,win,gc,x,y,&buf,1); \
  } \
}
#else
#define draw_face(pl,win,gc,x,y,face) \
{ \
  if(pl->use_pixmaps) \
  { \
    XCopyPlane(pl->gdisp,pl->pixmaps[(face)],win,gc,0,0,24,24, \
               (unsigned int) (x),(unsigned int) ((y) - 24),1); \
  } \
  else \
  { \
    XChar buf; \
    buf = FontindexToXChar((Fontindex) (face)); \
    XDRAWIMAGESTRING(pl->gdisp,win,gc,x,y,&buf,1); \
  } \
}
#endif

/*
 * Have to define LOG() to nothing if NO_LOG is defined.
 */
#ifdef NO_LOG
#define LOG()
#endif

#endif /* GLOBAL_H */
