#! /bin/csh -f

# Usefull for making an index laTex file from *.idx file

if ( $#argv == "0" ) then
  echo Usage: $0 "<idxfilename>"
  exit 0
endif
 
set idxfile = $1 
set tempfile = $1.tmp

sed -e '1,$s/'\indexentry'/ /' -e '1,$y/{/ /' -e '1,$y/}/ /' $idxfile > $tempfile

set data = "`cat $tempfile | sort +1 -d -f`" 
rm -f $tempfile

if ($#data == 0) exit 0

# flag the repeated entries
set i = 2
set line = ( `echo "$data[1]"` )
while ( $i <= $#data )
  set nline = ( `echo "$data[$i]"` )

  if ( "`echo $line`" == "`echo $nline`" ) then 
    set data[$i] = "REPEATED"
  else
    set line = `echo $nline` 
  endif

  @ i++
end

set line = ( `echo "$data[1]"` )
set word = $line[2]
set j = 3
while ( $j < $#line )
  set word = `echo $word $line[$j]`
  @ j++
end    
set pagefile = $tempfile.tmp
rm -f $pagefile
echo $line[$#line] > $pagefile
set oldline = ( `echo $line` ) 
set noline = $#oldline

set i = 2
set line = ( `echo "$data[$i]"` )
set last = $#data
@ last++
while ( $i <= $last )
  if( $i != $last ) set line = ( `echo "$data[$i]"` )

  if( "`echo $line`" == "REPEATED" ) goto skip

  set newword = $line[2]
  set j = 3
  while ( $j < $#line )
     set newword = `echo $newword $line[$j]` 
     @ j++
  end

  if( ($i != $last ) && ( "`echo $word`" == "`echo $newword`" ) ) then
    echo $line[$#line] >> $pagefile
  else 
    set op = `cat $pagefile | sort -b -n` 
    echo "\item" $word	$op >> $tempfile 

    rm -f $pagefile
    echo $line[$#line] > $pagefile
    set oldline = ( `echo $line` ) 
    set word = $oldline[2]
    set noline = $#oldline
    set j = 3
    while ( $j < $#oldline )
       set word = `echo $word $oldline[$j]` 
       @ j++
    end
  endif

skip:
  @ i++
end

rm -f $pagefile
# You may need to change the path of these echo's.  Using
# csh's built in echo is nonreliable, as what it does may depend
# on the os it seems.
/bin/echo "\\begin{theindex}"
sort -d $tempfile
/bin/echo "\\end{theindex}"
rm -f $tempfile

exit 0
