/*
 * static char *rcsid_loger_c =
 *   "$Id: logger.c,v 1.3 1997/03/09 04:13:24 master Exp master $ ";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#ifndef NO_LOG

#include <stdarg.h>
#include <global.h>
#include <funcpoint.h>

/*
 * Logs a message to stderr, or to file, and/or even to socket.
 * Or discards the message if it is of no importanse, and none have
 * asked to hear messages of that logLevel.
 * logLevels can be logError (always printed), llevDebug, and llevMonster.
 */

void LOG (LogLevel logLevel, char *format, ...)
{
#ifdef SERVER
  char buf[20480];  /* This needs to be really really big - larger
		     * than any other buffer, since that buffer may
		     * need to be put in this one.
		     */
  sockets *s;
#endif

  va_list ap;
  va_start(ap, format);

#ifdef SERVER
  buf[0] = '\0';
  if (logLevel <= settings.debug)
  {
    vsprintf(buf, format, ap);
    fputs(buf, logfile);
  }
  for (s = first_socket; s != (sockets *) NULL; s = s->next)
    if(s->debug && logLevel <= s->debug)
    {
      if(buf[0] == '\0')
        vsprintf(buf, format, ap);
      if(write(s->fd,buf,strlen(buf)) == -1)
        perror("log/write");
    }
#else
  if (logLevel <= settings.debug)
    vfprintf(logfile, format, ap);
#endif
  if (!exiting && !trying_emergency_save &&
      logLevel == llevError && ++nroferrors > MAX_ERRORS) {
    exiting = 1;
    if (!trying_emergency_save)
      (*emergency_save_func) (0);
    if (!editor)
	fatal(TOO_MANY_ERRORS);
  }
  va_end(ap);
}
#endif
