/*
 * static char *rcsid_init_c =
 *   "$Id: init.c,v 1.20 1997/03/09 04:06:13 master Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#define EXTERN
#include <global.h>
#include <object.h>

/* You unforunately need to looking in include/structs.h to see what these
 * correspond to.
 */
struct Settings settings = {
NULL, "logfile", PORT, CSPORT,	/*chrfont, logfile, port, new cs port */
SERVER_OFF, 1, Dm_Font,		/* -server option, fixfontpath, displaymode */
1, 0, 0,			/* synchronize, bw only, noadd */
#ifdef DEBUG
  llevDebug,
#else
  llevError,
#endif
0, 0, 0,    /* split, dumpvalues, daemonmode */
0, /* argc */
NULL, /* argv */
LIBDIR, FONTDIR, PLAYERDIR, MAPDIR, ARCHETYPES,TREASURES, 
#ifdef ITEMS_DIR
ITEMS_DIR ,
#else
"",
#endif
TMPDIR
};


/*
 * It is vital that init_library() is called by any functions
 * using this library.
 * If you want to lessen the size of the program using the library,
 * you can replace the call to init_library() with init_globals() and
 * init_function_pointers().  Good idea to also call init_vars and
 * init_hash_table if you are doing any object loading.
 */

void init_library() {
    init_environ();
    init_globals();
    init_function_pointers();
    init_hash_table();
    init_objects();
    init_vars();
    init_block();
    ReadBmapNames ();
    init_archetypes();	/* Reads all archetypes from file */
    init_dynamic ();
}

/* init_environ initializes values from the environmental variables.
 * it needs to be called very early, since command line options should
 * overwrite these if specified.
 */
void init_environ() {
#ifndef SECURE
    char *cp;

    cp=getenv("CROSSFIRE_LIBDIR");
    if (cp) settings.libdir=cp;
    cp=getenv("CROSSFIRE_FONTDIR");
    if (cp) settings.fontdir=cp;
    cp=getenv("CROSSFIRE_PLAYERDIR");
    if (cp) settings.playerdir=cp;
    cp=getenv("CROSSFIRE_MAPDIR");
    if (cp) settings.mapdir=cp;
    cp=getenv("CROSSFIRE_ARCHETYPES");
    if (cp) settings.archetypes=cp;
    cp=getenv("CROSSFIRE_TREASURES");
    if (cp) settings.treasures=cp;
#ifdef UNIQUE_ITEMS
    cp=getenv("CROSSFIRE_ITEMSDIR");
    if (cp) settings.uniquedir=cp;
#endif
#endif
    cp=getenv("CROSSFIRE_TMPDIR");
    if (cp) settings.tmpdir=cp;
}
    

/*
 * Initialises all global variables.
 * Might use environment-variables as default for some of them.
 */

void init_globals() {
  logfile = stderr;
  exiting = 0;
  delete_last_file=0;
  first_player=NULL;
  first_friendly_object=NULL;
  first_map=NULL;
  first_treasurelist=NULL;
  first_artifactlist=NULL;
  first_archetype=NULL;
  warn_archetypes=0;
  first_map=NULL;
#if 0
  write_state=0;
  write_pos=0;
  write_d=0;
  button_flag=0;
  last_bard=0;
  fix_walls=0;
  monsters = 1;
  generators = 1;
  hidden = 0;
  others = 1;
#endif
  last_micro = 0;
  nroftreasures = 0;
  nrofartifacts = 0;
  nrofallowedstr=0;
  ring_arch = NULL;
  amulet_arch = NULL;
  staff_arch = NULL;
  undead_name = add_string("undead");
  name = strdup_local("crossfire");
  active_socket = (sockets *) NULL;
  first_socket = (sockets *) NULL;
  font_graphic = FONTNAME;
  trying_emergency_save = 0;

  init_defaults();
}

/*
 * Sets up and initialises the linked list of free and used objects.
 * Allocates a certain chunk of objects and puts them on the free list.
 * Called by init_library();
 */

void init_objects() {
  int i;
/* Initialize all objects: */
  free_objects=objarray;
  objects=NULL;
  active_objects = NULL;
  objarray[0].prev=NULL,
  objarray[0].next= &objarray[1],
  SET_FLAG(&objarray[0], FLAG_REMOVED);
  SET_FLAG(&objarray[0], FLAG_FREED);
  for(i=1;i<STARTMAX-1;i++) {
    objarray[i].next= &objarray[i+1];
    objarray[i].prev= &objarray[i-1];
    SET_FLAG(&objarray[i], FLAG_REMOVED);
    SET_FLAG(&objarray[i], FLAG_FREED);
  }
  objarray[STARTMAX-1].next=NULL;
  objarray[STARTMAX-1].prev= &objarray[STARTMAX-2];
  SET_FLAG(&objarray[STARTMAX-1], FLAG_REMOVED);
  SET_FLAG(&objarray[STARTMAX-1], FLAG_FREED);
}

/*
 * Initialises global variables which can be changed by options.
 * Called by init_library().
 */

void init_defaults() {
  editor=0;
  maplevel=0; /* What level the map we're editing has */
  nroferrors=0;
}


void init_dynamic () {
    archetype *at = first_archetype;
    while (at) {
	if (at->clone.type == MAP && EXIT_PATH (&at->clone)) {
	    strcpy (first_map_path, EXIT_PATH (&at->clone));
	    return;
	}
	at = at->next;
    }
    LOG(llevDebug,"You Need a archetype called 'map' and it have to contain start map\n");
    exit (-1);
}
