#include <stdio.h>
#include "tcplib.h"
#include "xmalloc.h"
#include "timelib.h"

const int port=8855;
/* Remote and local machines need to be the same type for this to work */

void Send(char *host,int npackets,int fill,int sleepsec)
{
  int l,s;
  char *buf;
  TcpSocket conn;
  struct timeval start,finish;
  buf = xmalloc(fill+sizeof(struct timeval));

  conn = GetConnection(host,port);
/*  TcpLibBufferOutput(conn,1);*/
  sleep(sleepsec);
  srandom(time(NULL)>>1 ^ getpid()<<3);
  for(l=0;l<npackets;l++) {
    gettimeofday(&start,NULL);
    printf("Send %d\n",l);
    *((struct timeval *)buf) = start;
    SendSizedMsg(conn,buf,fill + sizeof(struct timeval));
    gettimeofday(&finish,NULL);
    SendSizedMsg(conn,&finish,sizeof(struct timeval));
    printf("finish - start = %d\n",msDiff(finish,start));
/* Depend on automatic flushing */
  }
  TcpLibFlush(conn);
  exit(0);
}
  
void Receive(int npackets,int sleepsecs)
{
  int l;
  char *buf;
  TcpSocket server,conn;
  struct timeval rcvstart,rcvend,sendstart,sendend;
  long size,total;

  buf = xmalloc(size);

  server = BecomeServer(port);
  WaitForInput(&server,1,TCPLIB_FOREVER);
  if (!HasInput(server)) {
    fprintf(stderr,"WaitForInput returned, but no input\n");
    exit(1);
  }
/*  printf("Accepting Connection\n");*/
  conn = AcceptConnection(server,NULL);
  total = 0;
  sleep(sleepsecs);
  for(l=0;l<npackets;l++) {
/*    printf("Receive %d\n",l);*/
    WaitForInput(&conn,1,TCPLIB_FOREVER);
    gettimeofday(&rcvstart,NULL);
    buf = GetSizedMsg(conn,&size);
    gettimeofday(&rcvend,NULL);
    sendstart = *((struct timeval *)buf);
    buf = GetSizedMsg(conn,&size);
    if (size != sizeof(struct timeval)) {
      fprintf(stderr,"Error, second packet has wrong size\n");
      abort();
    }
    sendend = *((struct timeval *)buf);
    printf("rcvstart - sendend = %d ms\n",msDiff(rcvstart,sendend));
  }
  exit(0);
}
    
main(int argc,char *argv[])
{
  int npackets,fill,sleepsecs;

  if ((argc == 4)&&
      (strcmp(argv[1],"-r")==0)&&
      ((npackets = atoi(argv[2]))>0)&&
      ((sleepsecs = atoi(argv[3]))>=0)) {
    /* Good args -- receive */
  } else if ((argc == 6)&&
	     (strcmp(argv[1],"-s")==0) &&
	     ((npackets = atoi(argv[3]))>0) &&
	     ((fill = atoi(argv[4]))>0) &&
	     ((sleepsecs = atoi(argv[5]))>=0)) {
    /* Good Args -- send */
  } else {
    fprintf(stderr,"Usage:%s <-r npackets|-s host npackets fill>\n",
	    argv[0]);
    exit(1);
  }
  
  if (strcmp(argv[1],"-s")==0)
    Send(argv[2],npackets,fill,sleepsecs);
  else
    Receive(npackets,sleepsecs);
  exit(1);
}

