#ifndef __tcplib_h
#define __tcplib_h

#include <errlib.h>

typedef struct __TcpSocket *TcpSocket;
#ifndef HAS_IOVEC
#define HAS_IOVEC 1
#endif

#if HAS_IOVEC
#include <sys/types.h>
#include <sys/uio.h>
#else
struct iovec {
  void *iov_base;
  int  iov_len;
};
#endif

void tcplib_SetDefaultErrorFunction(ErrorFunction erf);
TcpSocket BecomeServer(int port);
TcpSocket GetConnection(char *hostname,int port);
TcpSocket AcceptConnection(TcpSocket server,unsigned long *from);
TcpSocket MakeForeignFDConnection(int fd);
void CloseConnection(TcpSocket gone);
void TcpLibFlush(TcpSocket to);
void TcpLibBufferOutput(TcpSocket sock,int on);
void IOVSendMsg(TcpSocket to,struct iovec *vecs,int nvecs);
void SendMsg(TcpSocket to,char *msg,unsigned long msglen);
void SendSizedMsg(TcpSocket to,char *buf,long size);
void SendString(TcpSocket to,char *buf);
void GetMsg(TcpSocket from,char *buf,long size);
char *GetSizedMsg(TcpSocket from,long *size);
char *GetString(TcpSocket from);
#define TCPLIB_FOREVER -1
int WaitForInput(TcpSocket *socks,int nsocks,long msTimeout);
int HasInput(TcpSocket sock);
int GetTcpSocketFD(TcpSocket of);

/* Exceptions information -- see errlib.h */
extern char *tcplib_packagever;

extern char *tcplib_EProtoByName;
extern char *tcplib_ESocket;
extern char *tcplib_ESockOpt;
extern char *tcplib_EBindFailed;
extern char *tcplib_EListenFailed;
extern char *tcplib_ELookupFailed;
extern char *tcplib_ECloseErr;
extern char *tcplib_EConnectFailed;
extern char *tcplib_EInvalidArg;
extern char *tcplib_EAcceptBad;
extern char *tcplib_EWriteFailed;
extern char *tcplib_EWriteTooMuch;
extern char *tcplib_EReadError;   /* This can happen when the connection has
				     dropped */
extern char *tcplib_EBadWait;
extern char *tcplib_ESelectError;
extern char *tcplib_ENothingRead; /* This will ususally happen when the
				     connection has dropped */

#endif
