#ifndef __inttypes_h
#define __inttypes_h

/* Attempt to get a size which is at least 32 bits long, yes a long
   is supposed to be at least 32 bits, but an int is supposed to be
   the most efficient size */

/* 
   UM32B stands for Unsigned Minimum of 32 Bits 
   SM32B stands for Signed Minimum of 32 Bits 
   U32B stands for Unsigned 32 Bits
   S32B stands for Signed 32 Bits
*/

#define INTTYPES_INTSIZE4 1

#if INTTYPES_INTSIZE4
typedef unsigned long UM32B;
typedef signed long SM32B;
#else
typedef unsigned int UM32B;
typedef signed int SM32B;
#endif
typedef SM32B xint;

#if INTTYPES_INTSIZE4
typedef unsigned int U32B;
typedef int S32B;
#elif INTTYPES_LONGSIZE4
typedef unsigned long U32B;
typedef long S32B;
#else
#include "/no/such/file/neither.ints.nor.longs.are.32.bits.long"
@@@ die die die -- neither ints nor longs are 32 bits long @@@
#endif

#endif

