#include "libc.h"
#include "errlib.h"
#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
#include <errno.h>

/*
 *   eutl - A collection of useful libraries
 *          This part is errlib -- a unified error handling library.
 *
 *   (c) Copyright 1993 Eric Anderson 
 *
 * My thanks to Geoffrey Collyer and Henry Spencer for providing the basis
 * for this copyright.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. The authors are not responsible for the consequences of use of this
 *    software, no matter how awful, even if they arise from flaws in it.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Since few users ever read sources,
 *    credits must appear in the documentation.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.  Since few users
 *    ever read sources, credits must appear in the documentation.
 *
 * 4. This notice may not be removed or altered.
 */

char *errlib_packagever = "ErrLib V1.0";
char *errlib_EOverflowBuffer = "Error Message Buffer Overflow";
char *internal_Einternal = "Internal Package error";

char *exception_progname = "Unknown Program";
char *exception_package = NULL;
char *exception_errmsg = NULL;
char *exception_eid = NULL;

exceptionStruct *__errlib_top = NULL;

static void DoLongJmpErf(int printerr,char *package,char *errid, char *errfmt,
			 va_list args)
{
  static char buf[1024];

  buf[1024] = '\0';
  vsprintf(buf, errfmt, args);
  if (buf[1024]!= '\0') {
    if (printerr)
      fprintf(stderr,
	      "%s: Error in package %s: Internal sprintf buffer overflow.\n",
	      exception_progname,errlib_packagever);
    throwerr(errlib_packagever,
	     errlib_EOverflowBuffer,"Internal sprintf buffer overflow\n");
  }
  if (printerr)
    fprintf(stderr,"%s: Error in package %s: %s",
	    exception_progname,package,buf);
  throwerr(package,errid,buf);
}

void LongJmpPrintErrorFunction(char *package,char *errid,char *errfmt, ...)
{
  va_list args;

  va_start(args,errfmt);
  DoLongJmpErf(1,package,errid,errfmt,args);
}

void LongJmpErrorFunction(char *package,char *errid,char *errfmt, ...)
{
  va_list args;

  va_start(args,errfmt);
  DoLongJmpErf(0,package,errid,errfmt,args);
}

static void DoAbortErrorFunction(char *package,char *errid,char *errfmt,
				 va_list args)
{
  (void)fprintf(stderr,"Fatal Error in package %s:",package);
  vfprintf(stderr,errfmt,args);
  exit(1);
  fprintf(stderr,"Some dufus is catching abort signals and not aborting\n");
  signal(SIGABRT,SIG_DFL);
  abort();
}

void AbortErrorFunction(char *package,char *errid,char *errfmt, ...)
{
  va_list args;
  va_start(args,errfmt);
  DoAbortErrorFunction(package,errid,errfmt,args);
}

void throwerr(char *package,char *errid,char *buf)
{
  exception_package = package;
  exception_eid = errid;
  exception_errmsg = buf;
  if (__errlib_top == NULL) {
    AbortErrorFunction(errlib_packagever,"unhandled exception",
		       "%s::ErrLib: Unhandled Exception in Package %s.\n   %s",
		       exception_progname,package,buf);
  }
  if (__errlib_top->cur != __errlib_top) {
    AbortErrorFunction(errlib_packagever,"mangled exception",
		       "%s::ErrLib: Exception Stack Mangled -- Exception in %s.\n   %s",
		       exception_progname,package,buf);
  }
  longjmp(__errlib_top->towhere,1);
}

void errlib_setprogname(char *progname)
{
  exception_progname = progname;
}

#ifdef sun
extern int sys_nerr;
extern char *sys_errlist[];

char *strerror(int errno)
{
  if (errno<0 || errno>sys_nerr)
    return "Unknown Error Code";
  return sys_errlist[errno];
}
#endif
