#include "debuglib.h"
#include <errlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>

#include <chain-hash.h>
#include <libc.h>

char *debuglib_packagever = "DebugLib V1.0";
char *debuglib_Ecantcreatetable = "Unable to create debugging table";
char *debuglib_Egeterror = "Error Getting stored value from table";

static ErrorFunction Erf = LongJmpErrorFunction;

static HashTable debugtable;
int __debuglib_debugging_on;

void SetDebuggingValue(char *arg,int val)
{
  if (!debugtable) {
    debugtable = CreateHashTable(-500,NULL);
    if (debugtable == NULL) {
      Erf(debuglib_packagever,debuglib_Ecantcreatetable,
	  "Unable to create the debugging table\n");
    }
    __debuglib_debugging_on = 1;
  }
  HashOverwrite(debugtable,arg,strlen(arg),&val,sizeof(int));
}

void GetDebuggingArguments(int *argc,char **argv)
{
  int l;
  for(l=1;l<*argc;l++) {
    if (*(argv[l]) == '-') {
      char *e; /* equal pos */
      char *a; /* arg */
      int v; /* value */
      int j; /* loop for moving argv down */
      if (*(argv[l]+1) == '-')
	break; /* Respect -- convention as end of arguments */
      if (*(argv[l]+1) != 'D')
	continue; /* not our argument */
      if ((e = index(argv[l],'=')) != NULL) {
	*e = '\0';
      }
      /* Grab values */
      a = strdup(argv[l]);
      if (e) {
	v = atoi(e+1);
      } else {
	v = 1;
      }
      /* Shift down argv stuff */
      (*argc)--;
      l--; /* since argv shifted down, backup the loop */
      for(j=l;j<*argc;j++)
	argv[j] = argv[j+1];
      /* Store Debugging Information */
      SetDebuggingValue(a+2,v);
      free(a);
    }
  }
}

int GetDebuggingValue(char *debugname)
{
  int ret,found;
  char *c; /* copy */
  char *t; /* tmp for backing up the debugging name being checked */

  found = 0;
  c = strdup(debugname);
  if (c==NULL)
    Erf(debuglib_packagever,debuglib_Egeterror,
	"Error duplicating string '%s'\n",debugname);
  while(1) {
    WITH_HANDLING {
      ret = *(int *)HashLookup(debugtable,c,strlen(c));
      found = 1;
    } HANDLE {
      BEGIN_MATCH;
      XMATCH(chainhash,badlookup) {
      } END_MATCH;
    } END_HANDLING;
    if (found)
      break;
    /* Backup the debugging name */
    t = rindex(c,':');
    if (t==NULL) {
      free(c);
      return 0;/* Not found and no parent found */
    }
    *t = '\0';
  }
  free(c);
  return ret;
}

