
#include <global.h>
#include <object.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <skills.h>
#include <spells.h>


/* Don't change the order here w/o changing the skills.h file */

skill skills[] = {
    { "stealing", 0, 0 }, 
    { "lockpicking", 0, 0 }, 
    { "hiding", 0, 0 }, 
    { "smithery", 0, 0 }, 
    { "bowyer", 0, 0 }, 
    { "jewelery", 0, 0 }, 
    { "alchemy", 0, 0 }, 
    { "thaumaturgy", 0, 0 }, 
    { "literacy", 0, 0 }, 
    { "bargaining", 0, 0 },
    { "jumping", 0, 0 }, 
    { "sense magic", 0, 0 }, 
    { "oratory", 0, 0 },
    { "singing", 0, 0 }, 
    { "sense curse", 0, 0 }, 
    { "find traps", 0, 0 }, 
    { "meditation", 0, 0 }, 
    { "boxing", 0, 0 }, 
    { "wrestling", 0, 0 },
    { "karate", 0, 0 }, 
    { "mountaineer", 0, 0 }, 
    { "woodsman", 0, 0 },
    { "inscription", 0, 0 }
#if 0
    { "swordsmanship" },
    { "herblore" },
#endif
};

/* Initial coding: 6 Sep 1994, Nick Williams (njw@cs.city.ac.uk) */

/* Generalized code + added hiding and lockpicking skills, */
/* March 3, 1995, brian thomas (thomas@nomad.astro.psu.edu) */

/* Added more skills, fixed bug in stealing code */
/* April 21, 1995, brian thomas (thomas@nomad.astro.psu.edu) */

/* Added more skills, fixed bugs, see skills.h */ 
/* May/June, 1995, brian thomas (thomas@nomad.astro.psu.edu) */

/* 
 * When stealing: dependent on the intelligence/wisdom of whom you're
 * stealing from (op in attempt_steal), offset by your dexterity and
 * skill at stealing. They may notice your attempt, whether successful
 * or not. 
 */

int
attempt_steal(object* op, object* who)
{
    object* success = 0;	/* did we get anything? */
    int alarmed = 0;		/* was the thief caught? */
    int chance;
    object* tmp;
    object* next;

    if (op->type == PLAYER || QUERY_FLAG(op, FLAG_MONSTER)) {
	/* Go thru their inventory, stealing */
	for(tmp = op->inv; tmp != NULL; tmp = next) {
	    next = tmp->below;
	    /* you can't steal worn items, wiz stuff or innate abilities */
	    if (QUERY_FLAG(tmp,FLAG_WAS_WIZ) 
	 	|| QUERY_FLAG(tmp, FLAG_APPLIED) 
	 	|| tmp->type == SKILL  
 		|| tmp->type == ABILITY) {
		continue;
	    }
	    /* Okay, try stealing this item. Dependent on dexterity of thief */
	    /* NYI: Also, dependent on value of thievery skill */
	    /* The current calculation gives a random number around 15 */
	    /* BT hack -- its probably much harder to steal from hostile
	     * beings! - alter the chances of success to reflect this 
	     */
	    if(QUERY_FLAG(tmp, FLAG_UNAGGRESSIVE))
		chance = (RANDOM()%30+RANDOM()%30)/2;
	    else
		chance = (RANDOM()%80+RANDOM()%80)/2;

	    if (chance < (who->stats.Dex)) {
		pick_up(who, tmp);
		/* If you steal something heavy off them, they're bound to notice */
		if (tmp->weight > (200*(RANDOM()%who->stats.Dex)-(RANDOM()*5+1))) {
		    alarmed = 1;
		}
		success = tmp;
		break;
	    }
	}
    }
    if (alarmed || RANDOM()%25 > who->stats.Dex) {
	/* play_sound("stop! thief!"); kindofthing */
	if (op->type != PLAYER) {
	    /* The unaggressives look after themselves 8) */
	    CLEAR_FLAG(op, FLAG_UNAGGRESSIVE);
	    npc_call_help(op);
	} else {
	    char buf[MAX_BUF];
	    /* Notify the other player */
	    if (success && who->stats.Int > RANDOM()%20) {
		sprintf(buf, "Your %s has gone missing!", query_name(success));
	    } else {
		sprintf(buf, "Your pack feels strangely lighter.");
	    }
	    new_draw_info(NDI_UNIQUE, 0,op,buf);
	    if (!success) {
		if (who->invisible) {
		    sprintf(buf, "you feel itchy fingers getting at your pack.");
		} else {
		    sprintf(buf, "%s looks very shifty.", query_name(who));
		}
		new_draw_info(NDI_UNIQUE, 0,op,buf);
	    }
	}
    }
    return success? 1:0;
}

void steal(object* op, int dir)
{
    object *tmp, *next;
    int x = op->x + freearr_x[dir];
    int y = op->y + freearr_y[dir];
 
    if(dir == 0) {
	/* Can't steal from ourself! */
	return;
    }

    if(wall(op->map,x,y)) {
	return;
    }

    /* Find the topmost object at this spot */
    for(tmp = get_map_ob(op->map,x,y);
	tmp != NULL && tmp->above != NULL;
        tmp = tmp->above);

    /* For all the stacked objects at this point, attempt a steal */
    for(; tmp != NULL; tmp = next) {
      next = tmp->below;
      /* Minor hack--for multi square beings - make sure we get 
       * the 'head', 'tail' objects have no inventory! - b.t. 
       */ 
      if (tmp->head) tmp=tmp->head;
      if (attempt_steal(tmp, op)) {
	  /* Break out here, coz one success is enough */
	  return;
      }
    }
}

/* Implementation by bt. (thomas@nomad.astro.psu.edu) */

void pick_lock(object *pl, int dir)
{
    char buf[MAX_BUF];
    object *tmp; 
    int x = pl->x + freearr_x[dir];
    int y = pl->y + freearr_y[dir];

    if(dir == 0) {
        /* No door/locks on you to pick */
        return;
    }

/* For all the stacked objects at this point find a door*/

    sprintf(buf, "There is no lock there.");

    for(tmp=get_map_ob(pl->map,x,y); tmp; tmp=tmp->above) {
      if(!tmp) continue;
      switch(tmp->type) { 
        case DOOR:
            if (attempt_pick_lock(tmp, pl))
                sprintf(buf, "you pick the lock.");
            else 
                sprintf(buf, "you fail to pick the lock.");
	    break;
        case LOCKED_DOOR: 
            sprintf(buf, "you can't pick that lock!");
	    break;
   	default: 
	    break;
      }
    }
    new_draw_info(NDI_UNIQUE, 0,pl,buf);
}      

int attempt_pick_lock ( object *door, object *pl)
{
    int bonus = (pl->level /5), difficulty= pl->map->difficulty ? 
	pl->map->difficulty : 0;
    int success = 0, number;        /* did we get anything? */

  /* Try to pick the lock on this item (doors only for now). 
   * Dependent on dexterity/level of the player and  
   * the map level difficulty. 
   */

    number = (RANDOM()%30+RANDOM()%30)/2; 
    if (number < ((pl->stats.Dex + bonus) - difficulty)) { 
      remove_door(door);
      success = 1;
    } else if (door->inv && door->inv->type==RUNE) {  /* set off any traps? */ 
		spring_trap(door->inv,pl); 	       
    } 
    return success;
}

/* HIDE PLAYER CODE . Right now, player becomes 'invisible' for
 * a short while (success and duration dependant on player level,
 * dexterity, charisma, level and map difficulty
 * Players have a good chance of becoming 'unhidden' if they move
 * and like invisiblity will be come visible if they attack
 * Implemented by b.t. (thomas@nomad.astro.psu.edu)
 */ 

void hide(object *pl) {
  char buf[MAX_BUF];
  int level=(pl->level); 

  if(pl->type!=PLAYER) return;  /* only players may hide right now */ 

/* the preliminaries -- Can we really hide now? */
/* this keeps players from using invisibilty spells and hiding */

  if (QUERY_FLAG(pl, FLAG_MAKE_INVIS)) {
        sprintf(buf,"You don't need to hide while invisible!");
        new_draw_info(NDI_UNIQUE, 0,pl,buf);
        return;
  } else if (!pl->hide && pl->invisible>0) { 
        sprintf(buf,"Your attempt to hide breaks the invisibility spell!"); 
        pl->invisible= 0;
        pl->contr->tmp_invis=0;
	if(QUERY_FLAG(pl, FLAG_UNDEAD)) CLEAR_FLAG(pl, FLAG_UNDEAD);
        new_draw_info(NDI_UNIQUE, 0,pl,buf);
	update_object(pl);
        return;
  } 
 
  if(pl->hide && pl->invisible>30*level) {
       sprintf(buf, "You are as well hidden as you can get."); 
       new_draw_info(NDI_UNIQUE, 0,pl,buf);
       return;
  }
  
  if(attempt_hide(pl)) { 
     sprintf(buf, "You hide in the shadows.");
     update_object(pl);
  } else
     sprintf(buf, "You fail to conceal yourself.");

  new_draw_info(NDI_UNIQUE, 0,pl,buf);
}

int attempt_hide(object *pl) {
  int level=(pl->level)/5, difficulty=pl->map->difficulty;
  int number,dexterity=pl->stats.Dex;
  int success = 0,charisma=(pl->stats.Cha)/2;        

/*  Hiding success and duration dependant on player level,
 *  dexterity, charisma, level and map difficulty
 */

    number = (RANDOM()%20+RANDOM()%30)/2;
    if (number < (dexterity + level - difficulty - (charisma/2))) {
	success = 1;
	pl->invisible+= 100 + level*dexterity;  /* set the level of 'hiddeness' */
	pl->contr->tmp_invis=1;
	pl->hide=1;
    }
    return success;
}

void
jump(object *pl, int dir) 
{
 char buf[MAX_BUF];
 int spaces=0,stats=((pl->stats.Str)
	*(pl->stats.Str)*(pl->stats.Str)*(pl->stats.Dex));

 	if(pl->type!=PLAYER) return;  /* only players may jump right now */

 	if(pl->carrying!=0)		/* don't want div by zero !! */	 
	     spaces=(int) (stats/pl->carrying);
 	else
		spaces=2;	/* pl has no objects - gets the far jump */ 

 	if(spaces>2)
		 spaces = 2;
 	else if(spaces==0) {
		sprintf(buf, "You are carrying too much weight to jump.");
  		new_draw_info(NDI_UNIQUE, 0,pl,buf);
		return;
 	}
 	(void) attempt_jump(pl,dir,spaces);
	return;
}

int attempt_jump (object *pl, int dir, int spaces) {
  char buf[MAX_BUF];
  object *tmp;
  int i,dx=freearr_x[dir],dy=freearr_y[dir];

 /* Jump loop. Go through spaces opject wants to jump. Halt the
  * jump if a wall or creature is in the way. We set FLAG_FLYING
  * temporarily to allow player to aviod exits/archs that are not 
  * fly_on, fly_off. This will also prevent pickup of objects 
  * while jumping over them.  
  */ 

  remove_ob(pl);
  SET_FLAG(pl,FLAG_FLYING);
  for(i=0;i<=spaces;i++) { 
      for(tmp=get_map_ob(pl->map,pl->x+dx,pl->y+dy);
        tmp;tmp=tmp->above) { 
	   if(wall(tmp->map,tmp->x,tmp->y)) {           /* Jump into wall*/ 
	     sprintf(buf, "Your jump is blocked.");
             new_draw_info(NDI_UNIQUE, 0,pl,buf);
	     (void) stop_jump(pl,i,spaces);
	     return 0;
	   } 
	   if(QUERY_FLAG(tmp,FLAG_MONSTER)          /* Jump into creature */ 
	            || tmp->type==PLAYER ) {   
	     sprintf(buf, "You jump into%s%s.", 
	       tmp->type == PLAYER ? " " : " the ", tmp->name);
             new_draw_info(NDI_UNIQUE, 0,pl,buf);
	     if(tmp->type!=PLAYER || pl->contr->party_number==-1 ||
		 pl->contr->party_number!=tmp->contr->party_number) 
 	     		(void) attack_ob(tmp,pl);    /* pl makes an attack */ 
	     (void) stop_jump(pl,i,spaces);
	     return 0;
	   }
	   if(tmp->type==EXIT			     /* pl jump through exit */ 
		&& QUERY_FLAG(tmp, FLAG_FLY_ON)) { 
             pl->x+=dx,pl->y+=dy;
	     (void) stop_jump(pl,i,spaces);
	     return 0;
	   }
      }
      if(out_of_map(pl->map,pl->x+dx,pl->y+dy)) {
  		(void) stop_jump(pl,i,spaces);
		return 1;
      } else  
        pl->x+=dx,pl->y+=dy;
  }
  (void) stop_jump(pl,i,spaces);
  return 1;
}
/* End of jump. Clear flags, restore the map, and 
 * freeze the player a while to simulate the exahustion
 * of jumping.
 */

int stop_jump(object *pl, int dist, int spaces) {
 int load=dist/(pl->speed*spaces); 

  CLEAR_FLAG(pl,FLAG_FLYING);
  insert_ob_in_map(pl,pl->map);
  draw(pl);  
  pl->speed_left= (int) -FABS((load*8)+1);
  return 0;
}

/* this code is supposed to allow players to identify classes of
 * objects with the various "auto-ident" skills. Player must have
 * unidentified objects of the right type in order for the skill
 * to work. While multiple classes of objects may be identified, 
 * this code is kind of yucky -- it would be nice to make it a bit
 * more generalized. Right now, skills are embedded in this routine.  
 * by b.t. (thomas@nomad.astro.psu.edu) 
 */

void skill_ident(object *pl) {
  char buf[MAX_BUF];
  int success=0;

	if(!pl->chosen_skill) 	/* should'nt happen.... */ 
		return;

	if(pl->type != PLAYER) return; 	/* only players will skill-identify */

    	sprintf(buf, "You look at the objects you are carrying...");
    	new_draw_info(NDI_UNIQUE, 0,pl,buf);   

	switch (pl->chosen_skill->stats.sp) {
	   case SK_SMITH: 
	      	if(do_skill_ident(pl,WEAPON) || do_skill_ident(pl,ARMOUR)
		    || do_skill_ident(pl,BRACERS) || do_skill_ident(pl,CLOAK)
		    || do_skill_ident(pl,BOOTS) || do_skill_ident(pl,SHIELD)
		    || do_skill_ident(pl,GIRDLE)
		    || do_skill_ident(pl,HELMET) || do_skill_ident(pl,GLOVES))
               		if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                		draw_inventory(pl); 
				success=1;
			}
		break;
	   case SK_BOWYER:
		if(do_skill_ident(pl,BOW) || do_skill_ident(pl,ARROW))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
                break;
	   case SK_ALCHEMY:
                if(do_skill_ident(pl,POTION) || do_skill_ident(pl,POISON)
		    || do_skill_ident(pl,AMULET) || do_skill_ident(pl,CONTAINER))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
		break;
           case SK_JEWELER:
                if(do_skill_ident(pl,GEM) || do_skill_ident(pl,RING))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
                break; 
	   case SK_LITERACY:
                if(do_skill_ident(pl,SPELLBOOK) || do_skill_ident(pl,SCROLL)) 
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
		break;
           case SK_THAUMATURGY:
                if(do_skill_ident(pl,WAND) || do_skill_ident(pl,ROD) 
		    || do_skill_ident(pl,HORN))
                        if (pl->type == PLAYER && pl->contr->eric_server <= 0) { 
                                draw_inventory(pl); 
                                success=1; 
                        } 
                break;
	   case SK_DET_CURSE:
                if(do_skill_detect_curse(pl)) {
                        success=1;
                        sprintf(buf,"...and discover cursed items!");
                        new_draw_info(NDI_UNIQUE, 0,pl,buf);
                        draw_inventory(pl);
                }
                break;   
	   case SK_DET_MAGIC:
		if(do_skill_detect_magic(pl)) { 
			success=1;
                	sprintf(buf,"...and discover items imbued with mystic forces!");
                	new_draw_info(NDI_UNIQUE, 0,pl,buf);
			draw_inventory(pl);
		}
		break;
	   default:
		success=0;
		break;
	} 
	if(!success) {
		sprintf(buf,"...and learn nothing new.");
    		new_draw_info(NDI_UNIQUE, 0,pl,buf);
	}
}
 
int do_skill_detect_curse(object *pl) {
object *tmp;
int success=0;
 
/* check the player inventory - stop after 1st success or 
 * run out of unidented items 
 */ 
    for(tmp=pl->inv;tmp;tmp=tmp->below)
        if(!QUERY_FLAG(tmp,FLAG_IDENTIFIED) && !QUERY_FLAG(tmp,FLAG_KNOWN_CURSED)
            && (QUERY_FLAG(tmp,FLAG_CURSED) || QUERY_FLAG(tmp,FLAG_DAMNED)) ) {
                SET_FLAG(tmp,FLAG_KNOWN_CURSED);
                success=1;
        }
    return success;
}

int do_skill_detect_magic(object *pl) {
object *tmp;
int success=0;

/* check the player inventory - stop after 1st success or
 * run out of unidented items
 */
    for(tmp=pl->inv;tmp;tmp=tmp->below)
        if(!QUERY_FLAG(tmp,FLAG_IDENTIFIED) && !QUERY_FLAG(tmp,FLAG_KNOWN_MAGICAL)
	    && (is_magical(tmp) || always_magical(tmp)) ) { 
            	SET_FLAG(tmp,FLAG_KNOWN_MAGICAL);
		success=1;
	}
    return success;
}

int do_skill_ident(object *pl, int obj_class) {
  object *tmp;
  int success=0;

/* check the player inventory */
    for(tmp=pl->inv;tmp;tmp=tmp->below)
	if(!QUERY_FLAG(tmp,FLAG_IDENTIFIED) 
	   && need_identify(tmp) 
	   && !tmp->invisible && tmp->type==obj_class) { 
		identify(tmp);
     		if (pl->type==PLAYER) {
        	    new_draw_info_format(NDI_UNIQUE, 0, pl,
                      "You have %s.", long_desc(tmp));
        	    if (tmp->msg) {
          		new_draw_info(NDI_UNIQUE, 0,pl, "The item has a story:");
          		new_draw_info(NDI_UNIQUE, 0,pl, tmp->msg);
        	    }
        	    if (pl->contr->eric_server > 0)
            		esrv_send_item(pl, tmp);
        	}   
	        success = 1;
        }
    return success;
}  
/* Learn skill. This inserts the requested skill in the player's
 * inventory. The 'slaying' field of the scroll should have the 
 * exact name of the requested archetype (there should be a better way!?)
 * -bt. thomas@nomad.astro.psu.edu
 */

int
learn_skill (object *pl, object *scroll) {
object *tmp,*tmp2;
int i=0;
archetype *skill;

     if((skill=find_archetype(scroll->slaying))==NULL)
           return 8;
     tmp=arch_to_object(skill);
     if(tmp->level>pl->level) return 2;
/* check if player already has it */
     for(tmp2=pl->inv;tmp2;tmp2=tmp2->below) 
	if(!strcmp(tmp2->name,tmp->name)) i++;
     if(i>0) return 0;
/* Everything is cool. Give'em the skill */
     tmp->x=pl->x,tmp->y=pl->y;
     insert_ob_in_ob(tmp,pl);
     if (pl->contr->eric_server > 0)
         esrv_send_item(pl, tmp);
     return 1;
} 

/* players using this skill can 'charm' a monster --
 * into working for them. It can only be used on 
 * non-special (see below) 'neutral' creatures. 
 * -b.t. (thomas@nomad.astro.psu.edu)
 */

void use_oratory(object *pl, int dir) {
  int x=pl->x+freearr_x[dir],y=pl->y+freearr_y[dir];
  object *tmp;
 
	if(pl->type!=PLAYER) return;	/* only players use this skill */ 

        for(tmp=get_map_ob(pl->map,x,y);tmp;tmp=tmp->above) { 
        	if(!tmp) return;
		if(!QUERY_FLAG(tmp,FLAG_MONSTER)) continue; 
        	if(tmp->type==PLAYER) continue;	      /* can't persude players! */ 

                new_draw_info_format(NDI_UNIQUE, 
			0,pl, "You orate to the %s.",query_name(tmp));

	/* the following conditions limit who may be 'charmed' */

		if(!QUERY_FLAG(tmp,FLAG_UNAGGRESSIVE) &&   /* it's hostile! */ 
			!QUERY_FLAG(tmp, FLAG_FRIENDLY)) {  
                        new_draw_info_format(NDI_UNIQUE, 0,pl, 
			   "Too bad the %s is'nt listening!\n",query_name(tmp));
			return;	
		}
    	   /* it's already allied! */ 
                if(QUERY_FLAG(tmp,FLAG_FRIENDLY)&&(tmp->move_type==PETMOVE)){  
			if(get_owner(tmp)==pl) {
                           new_draw_info(NDI_UNIQUE, 0,pl, 
                             "Your follower loves your speach.\n");
                           return;  
		 	} else if(pl->level>tmp->level) { /* you steal the follower! */
		   	   set_owner(tmp,pl);	
                           new_draw_info_format(NDI_UNIQUE, 0,pl, 
                             "You convince the %s to follow you instead!\n"
			     ,query_name(tmp));
			   return;
			}
                } 

        	if(tmp->more || tmp->head) continue;  /* no multiple square monsters*/
		if(tmp->msg) continue; 	            /* no special message monsters */

	/* Ok, got a 'sucker' lets try to make them a follower */
        	if((tmp->level+1)<(RANDOM()%(pl->level)+((pl->stats.Cha-10)/2))) { 
                        new_draw_info_format(NDI_UNIQUE, 0,pl, 
			  "You convince the %s to become your follower.\n"
			  ,query_name(tmp));
       			set_owner(tmp,pl);
        		SET_FLAG(tmp,FLAG_MONSTER);
        		tmp->stats.exp = 0;
        		SET_FLAG(tmp,FLAG_FRIENDLY);
        		tmp->move_type = PETMOVE;
 			return;
		}
	/* maybe we made it angry */ 
        	if((pl->level+((pl->stats.Cha-10)/2))<RANDOM()%((2*tmp->level)+1)) { 
                        new_draw_info_format(NDI_UNIQUE, 0,pl, 
			  "Your speach angers the %s!\n",query_name(tmp)); 
        		if(QUERY_FLAG(tmp,FLAG_FRIENDLY)) {
        			CLEAR_FLAG(tmp,FLAG_FRIENDLY);
        			tmp->move_type = 0; 	/* needed? */ 
			}
        		CLEAR_FLAG(tmp,FLAG_UNAGGRESSIVE);
			return;
		}
	}
}

/* this skill allows the player to pacify nearby creatures.
 * Right now there are no limitations on who/what kind of 
 * non-player creatures that may be pacified. Also, right now
 * it is possible to re-pacify creatures that you have just
 * attacked! Need to find a variable to set (in the monster)
 * to prevent this.
 * I appologize for the naming of the skill, I couldnt think
 * of anything better! -b.t. 
 */

void singing(object *pl, int dir) {
  int x=pl->x+freearr_x[dir],y=pl->y+freearr_y[dir];
  object *tmp;

        if(pl->type!=PLAYER) return;    /* only players use this skill */

        for(tmp=get_map_ob(pl->map,x,y);tmp;tmp=tmp->above) {
                if(!tmp) return;
		if(!QUERY_FLAG(tmp,FLAG_MONSTER)) continue;
                if(tmp->type==PLAYER) continue;          /* can't affect players! */

                new_draw_info_format(NDI_UNIQUE,
                        0,pl, "You sing to the %s.\n",query_name(tmp));

		/* the following monsters can't be calmed */

		if(QUERY_FLAG(tmp,FLAG_SPLITTING)	/* have no ears! */ 
		   || QUERY_FLAG(tmp,FLAG_HITBACK)) break;	

		if(tmp->stats.Int > 5) break;	/* too smart! */
		if(tmp->level>15) break;	/* too powerfull */
		if(QUERY_FLAG(tmp,FLAG_UNDEAD)) /* undead dont listen! */ 
				break;

		if(QUERY_FLAG(tmp,FLAG_UNAGGRESSIVE) /* already calm */ 
		  ||QUERY_FLAG(tmp,FLAG_FRIENDLY)) 
			break;	

		if((tmp->level+1)<((RANDOM()%(pl->level+1))+(pl->stats.Cha-9)/2)){
		     SET_FLAG(tmp,FLAG_UNAGGRESSIVE);
                     new_draw_info_format(NDI_UNIQUE, 0,pl,
                       "You calm down the %s!\n",query_name(tmp));
		     return;
		} else { 
                     new_draw_info_format(NDI_UNIQUE, 0,pl,
                  	"Too bad the %s is'nt listening!\n",query_name(tmp));
		}
	}
}

/* The FIND_TRAPS skill. This routine is taken whole-hog from the 
 * command_search loop. It seemed easier to have a separate command,
 * rather than overhaul the existing code - this makes sure things 
 * still work for those people who don't want to have skill code 
 * implemented.
 * 4-21-95 I modified trap_see to allow greater trapdetection with the find trap
 * skill. This needs to be carried over into this routine here. -b.t.
 */
 
void find_traps (object *pl)
{  object *tmp,*tmp2;
   int i;
  /*First we search all around us for runes and traps, which are
    all type RUNE */
   for(i=0;i<9;i++) { 
        /*  Check everything in the square for trapness */
        if(out_of_map(pl->map,pl->x + freearr_x[i],pl->y + freearr_y[i])) continue;
        for(tmp = get_map_ob(pl->map, pl->x + freearr_x[i], pl->y +freearr_y[i]);
            tmp!=NULL;tmp=tmp->above) 
          {
            /*  And now we'd better do an inventory traversal of each
                of these objects' inventory */
            for(tmp2=tmp->inv;tmp2!=NULL;tmp2=tmp2->below)
                if(tmp2->type==RUNE) { if(trap_see(pl,tmp2,1)) trap_show(tmp2,tmp); }
            if(tmp->type==RUNE) { if(trap_see(pl,tmp,1)) trap_show(tmp,tmp);}
            }
   }
  return;
}  

/* This skill allows the player to regain a few sp or hp for a 
 * brief period of concentration. No armour or weapons may be 
 * wielded/applied for this to work. The amount of time needed
 * to concentrate and the # of points regained is dependant on
 * the level of the user. - b.t. thomas@astro.psu.edu 
 */ 

void meditate (object *pl) {
  object *tmp;
  int factor = 10/(1+(pl->level/10)+(pl->stats.Int/15)+(pl->stats.Wis/15)); 

    if(pl->type!=PLAYER) return;	/* players only */

    /* check if pl has removed encumbering armour and weapons */ 

    if(QUERY_FLAG(pl,FLAG_READY_WEAPON)) { 
        new_draw_info(NDI_UNIQUE,0,pl, 
	  "You can't concentrate while wielding a weapon!\n");	
	return;
    } else {
	for(tmp=pl->inv;tmp;tmp=tmp->below)
          if((tmp->type==ARMOUR || tmp->type==HELMET || tmp->type==SHIELD
		|| tmp->type==BOOTS || tmp->type==GLOVES)
  	     && QUERY_FLAG(tmp,FLAG_APPLIED)) {
         	new_draw_info(NDI_UNIQUE,0,pl, 
		  "You can't concentrate while wearing so much armour!\n");	
	  	return;
	  } 
    } 

    /* ok let's meditate!  Spell points are regained first, then once
     * they are maxed we get back hp. Actual incrementing of values
     * is handled by the do_some_living() (in player.c). This way magical
     * bonuses for healing/sp regeneration are included properly
     * No matter what, we will eat up some playing time trying to 
     * meditate. (see 'factor' variable for what sets the amount of time) 
     */

        new_draw_info(NDI_UNIQUE,0,pl, "You meditate."); 
        pl->speed_left -= (int) FABS(factor);

	if(pl->stats.sp < pl->stats.maxsp) {
	   pl->stats.sp++;
	   pl->last_sp = -1;
	} else if (pl->stats.hp < pl->stats.maxhp)  {
	   pl->stats.hp++;
	   pl->last_heal = -1;
	} else return;
	
	do_some_living(pl); 	
}

/* write_scroll() - this routine allows players to inscribe spell scrolls
 * of spells which they know. Backfire effects are possible with the
 * severity of the backlash correlated with the difficulty of the scroll 
 * that is attempted. -b.t. thomas@astro.psu.edu
 */

void write_scroll (object *pl) {
  object *scroll=pl->inv; 
  int success=0,confused=0,chosen_spell=-1;
	/* Check if we are ready to attempt inscription */

	if(pl->type!=PLAYER) return;
	chosen_spell=pl->contr->chosen_spell;
	if(chosen_spell<0) {
         	new_draw_info(NDI_UNIQUE,0,pl,"You need a spell readied in order to inscribe!"); 
		return; 
	}
	if(QUERY_FLAG(scroll,FLAG_UNPAID)) { 
         	new_draw_info(NDI_UNIQUE,0,pl,"You had better pay for that before you write on it.");
		return;
	}
        if(!scroll||scroll->type!=SCROLL) { /* top object in inventory must be a scroll */
                new_draw_info_format(NDI_UNIQUE,0,pl,"You cannot inscribe on %s",
                  !scroll ? "nothing" : query_short_name(scroll));
                return;  
        }         
	if(spells[chosen_spell].scroll_chance==0) { /* Uh oh. Tried to write non-scroll spell */
         	new_draw_info_format(NDI_UNIQUE,0,pl,"You can't inscribe the spell %s.",
			spells[chosen_spell].name);
		return;
	}
	if(spells[chosen_spell].sp>pl->stats.sp) {
         	new_draw_info_format(NDI_UNIQUE,0,pl,
		     "You don't have enough spell points to write a scroll of %s."
		      ,spells[chosen_spell].name);
		return;
	}

	/* ok, we are ready to try inscription */

	if(QUERY_FLAG(pl,FLAG_CONFUSED)) confused = 1;
	success = RANDOM()%(spells[chosen_spell].level*4) < pl->level ? 1 : 0;
	pl->stats.sp-=spells[chosen_spell].sp; /* lose sp no matter what */ 

	if(success) { 
		if(scroll->nrof) scroll->nrof = 1;
		if(!confused) {
			scroll->level= (pl->level>spells[chosen_spell].level ? 
				pl->level : spells[chosen_spell].level);
		} else {			/* a  confused scribe gets a random spell */ 
			chosen_spell=0;
			while (!spells[chosen_spell].scroll_chance) 
				chosen_spell=RANDOM()%NROFREALSPELLS; 
			scroll->level=pl->level>spells[chosen_spell].level ? 
				spells[chosen_spell].level : ((RANDOM()%pl->level)+1);
		}

		if(scroll->stats.sp==chosen_spell) 
         		new_draw_info(NDI_UNIQUE,0,pl,
				"You overwrite the scroll.");
		else { 
         		new_draw_info(NDI_UNIQUE,0,pl,
				"You succeed in writing a new scroll.");
			scroll->stats.sp=chosen_spell; 
		}

		draw_inventory(pl);
	} else  
		if(spells[chosen_spell].level>pl->level || confused){ /*backfire!*/
         	   new_draw_info(NDI_UNIQUE,0,pl,
			"Ouch! Your attempt to write a new scroll strains your mind!");
		   if(RANDOM()%2==1)   
			drain_specific_stat(pl,4); 
		     else 
		        confuse_player(pl,pl,99);
		   
		} else if(RANDOM()%pl->stats.Int<15) { 
         	   new_draw_info(NDI_UNIQUE,0,pl,
			"Your attempt to write a new scroll rattles your mind!");
		   confuse_player(pl,pl,99);
		} else
         	   new_draw_info(NDI_UNIQUE,0,pl,"You fail to write a new scroll.");

}
